package creditExample;

import id3.AbstractProperty;

public class IncomeProperty extends AbstractProperty {
	public static final String INCOME = "Income";
	public static final String $0_TO_$15K = "$0 to $15K";
	public static final String $15K_TO_$35K = "$15K to $35K";
	public static final String OVER_$35K = "over $35K";

	public IncomeProperty(String value) {
		super(value);
	}

	public boolean isLegalValue(String value){
		return (value.equals($0_TO_$15K) ||
				value.equals($15K_TO_$35K) ||
				value.equals(OVER_$35K));
	}

	public String getName(){
		return INCOME;
	}
}
